/* --------------------------------------------------------------
  BoxSetting.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

import Setting from './Setting';

/**
 * Class BoxSetting
 */
export default class BoxSetting extends Setting {
	/**
	 * Class Constructor 
	 */
	constructor() {
		super();
		
		/**
		 * Position in the boxes setting group.
		 *
		 * @type {Number}
		 */
		this.position = null;
	}
	
	/**
	 * Position Getter
	 *
	 * @return {Number}
	 */
	getPosition() {
		return this.position;
	}
	
	/**
	 * Position Setter
	 *
	 * @param {Number} position
	 *
	 * @return {BoxSetting}
	 */
	setPosition(position) {
		StyleEdit.Validator.isInt(position);
		this.position = position;
		return this;
	}
}
